import os

class nfomovie(Agent.Movies):
	name = 'NFO (Movie)'
	primary_provider = False
	languages = [Locale.Language.English]
	contributes_to = ['com.plexapp.agents.imdb', 'com.plexapp.agents.none']
	
	def search(self, results, media, lang):
		results.Append(MetadataSearchResult(id = media.primary_metadata.id, score = 100))
				
	def update(self, metadata, media, lang):
		##Fileroot and path
		(fileroot, ext) = os.path.splitext(os.path.basename(media.items[0].parts[0].file.decode('utf-8')))
		path = os.path.dirname(media.items[0].parts[0].file.decode('utf-8'))
				
		##Load NFO file
		nfoXML=XML.ElementFromString(Core.storage.load(path + "/" + fileroot + ".nfo"))

		##Parse NFO file
		
		#title
		try: metadata.title=nfoXML.xpath('./title')[0].text
		except: pass
		
		#tagline
		try: metadata.tagline=nfoXML.xpath('./tagline')[0].text
		except:pass

		#summary
		try: metadata.summary=nfoXML.xpath('./plot')[0].text
		except:pass

		#studio
		try: metadata.studio=nfoXML.xpath('./studio')[0].text
		except:pass

		#year
		try: metadata.year=int(nfoXML.xpath('./year')[0].text)
		except:pass
			
		#content rating
		try: metadata.content_rating=nfoXML.xpath('./mpaa')[0].text
		except:pass

		#rating
		try: metadata.rating=float(nfoXML.xpath('./rating')[0].text)
		except:pass
		
		#genres
		metadata.genres.clear()
		try:
			for tempgenre in nfoXML.findall('genre'):
				tempgenre2=tempgenre.text
				genres=tempgenre2.split(" / ")
				for genre in genres:
					metadata.genres.add(genre)
		except: pass
				
		#collection
		metadata.collections.clear()
		try:
			for collection in nfoXML.findall('collection'):
				metadata.collections.add(collection.text)
		except: pass
				
		#writers
		metadata.writers.clear()
		writers="None"
		try:
			for tempwriter in nfoXML.findall('credits'):
				tempwriter2=tempwriter.text
				writers=tempwriter2.split(" / ")
				if writers != "None":
					for writer in writers:
						Log(writer)
						metadata.writers.add(writer)
		except: Log("Exception parsing writers")
					
		#directors
		metadata.directors.clear()
		directors="None"
		try:
			for tempdirector in nfoXML.findall('director'):
				tempdirector2=tempdirector.text
				directors=tempdirector2.split(" / ")
				if directors != "None":
					for director in directors:
						Log(director)
						metadata.directors.add(director)
		except: pass

		#actors
		metadata.roles.clear()
		for actor in nfoXML.findall('./actor'):
			role=metadata.roles.new()
			try: role.role=actor.xpath("role")[0].text
			except: pass
			try: role.actor=actor.xpath("name")[0].text
			except: pass
